$("#plataforma").on('change', function () {
    if ($("#plataforma").val() == 'E') {
        $("#confirma").attr("required", "required");
        $(".confirma").show();
    } else {
        $("#confirma").removeAttr("required");
        $(".confirma").hide();
    }
    $("#verificaLogin").html('');
});

$("#checkLogin").on('click', function () {
    switch ($("#plataforma").val()) {
        case 'E':
            verificaEexpl($('#username').val(), $('#pass').val());
            break;
        case 'R':
            verificaRcampo($('#username').val(), $('#pass').val());
            break;
        case 'G':
            verificaGenpro($('#username').val(), $('#pass').val());
            break;
    }
});

$(document).ready(function () {
    $("#form").on('submit', function (e) {
        e.preventDefault();
        if ($("#plataforma").val() == 'E') {
            $.ajax({
                url: "https://www.ruralbit.com/api/api.php/setEntiGest",
                method: "POST",
                data: {
                    'API-user': 'ifap_plugin',
                    'API-pass': 'pluginIfAp2019!',
                    'user': document.getElementById('username').value,
                    'pass': btoa(document.getElementById('pass').value)
                },
                dataType: 'json'
            }).done(function (ret) {
                if (ret.ret == true) {
                    chrome.storage.sync.set(
                            {
                                plataforma: document.getElementById('plataforma').value,
                                username: document.getElementById('username').value,
                                password: document.getElementById('pass').value,
                                idpart: document.getElementById('idpart').value
                            },
                            function () { }
                    );
                    if (ret.confirma == 1) {
                        alert('Dados guardados! Foi iniciada a subscrição deste serviço.');
                    } else {
                        alert('Dados guardados!');
                    }
                } else {
                    alert("Login inválido! Por favor, verifique as suas credenciais.");
                }
            }).error(function (ret) {
                alert("Ocorreu um erro!");
            });
        } else {
            chrome.storage.sync.set(
                    {
                        plataforma: document.getElementById('plataforma').value,
                        username: document.getElementById('username').value,
                        password: document.getElementById('pass').value,
                        idpart: document.getElementById('idpart').value
                    },
                    function () {
                        alert('Dados guardados!');
                    }
            );
        }
    });

    chrome.storage.sync.get('plataforma', function (data) {
        document.getElementById('plataforma').value = typeof data.plataforma != 'undefined' ? data.plataforma : "E";
        document.getElementById('plataforma').dispatchEvent(new Event('change'));
    });
    chrome.storage.sync.get('username', function (data) {
        document.getElementById('username').value = typeof data.username != 'undefined' ? data.username : "";
    });
    chrome.storage.sync.get('password', function (data) {
        document.getElementById('pass').value = typeof data.password != 'undefined' ? data.password : "";
    });
    chrome.storage.sync.get('idpart', function (data) {
        document.getElementById('idpart').value = typeof data.idpart != 'undefined' ? data.idpart : "";
        document.getElementById('idpart').dispatchEvent(new Event('change'));
    });
});

function verificaEexpl(username, password) {
    $("#verificaLogin").html('');
    if (username != '' && password != '') {
        let send_data = {
            'API-user': 'ifap_plugin',
            'API-pass': 'pluginIfAp2019!',
            'user': username,
            'pass': btoa(password)
        };

        var xhr = new XMLHttpRequest();
        xhr.open("POST", "https://www.ruralbit.com/api/api.php/getEntiGest?" + param(send_data), true);
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status == 200) {
                    var ret = JSON.parse(xhr.responseText);

                    var text = '';
                    if (ret.length > 0) {
                        text = '<div class="alert alert-success" role="alert">\n\
                            <b>Login válido!</b>\n\
                            <ul>\n\
                                <li>Utlizador: <b>' + ret[0].nome + '</b></li>\n\
                                <li>NIF de gestão: <b>' + ret[0].gestao + '</b>' + (ret[0].c > 1 ? " (Válido para todos os NIFs desta gestão)" : "") + '</li>\n\
                                <li>NIF a faturar: <b>' + ret[0].facturacao + '</b></li>\n\
                                <li>Entidade: <b>' + ret[0].nome_entidade + '</b></li>\n\
                                <li>Tem subscrição do plugin ativa: <b>' + ret[0].tem_plugin + '</b></li>\n\
                            </ul>\n\
                        </div>';
                        if (ret[0].tem_plugin == 'Sim') {
                            $("#confirma").prop("checked", true);
                        }
                        $('#save').removeAttr('disabled');
                    } else {
                        text = '<div class="alert alert-danger" role="alert">\n\
                            <b>Login inválido!</b> Por favor, verifique as suas credenciais.\n\
                        </div>';
                        $('#save').attr('disabled', 'disabled');
                    }
                    $("#verificaLogin").html(text);
                } else {
                    alert("Ocorreu um erro!");
                    $('#save').attr('disabled', 'disabled');
                }
            }
        };
        xhr.send();
    }
}

function verificaRcampo(username, password) {
    $("#verificaLogin").html('');
    if (username != '' && password != '') {
        $.ajax({
            url: "https://www.ruralbit.com/api/api.php/getLoginRcampo",
            method: "POST",
            data: {
                'API-user': 'ifap_plugin',
                'API-pass': 'pluginIfAp2019!',
                'user': username,
                'pass': btoa(password)
            },
            dataType: 'json'
        }).done(function (ret) {
            var text = '';
            if (ret.length > 0) {
                text = '<div class="alert alert-success" role="alert">\n\
                            <b>Login válido!</b>\n\
                            <ul>\n\
                                <li>Utlizador: <b>' + ret[0].nome + '</b></li>\n\
                                <li>Entidade: <b>' + ret[0].enti + ' - ' + ret[0].nome_entidade + '</b></li>\n\
                            </ul>\n\
                        </div>';
                $('#save').removeAttr('disabled');
            } else {
                text = '<div class="alert alert-danger" role="alert">\n\
                            <b>Login inválido!</b> Por favor, verifique as suas credenciais.\n\
                        </div>';
                $('#save').attr('disabled', 'disabled');
            }
            $("#verificaLogin").html(text);
        }).error(function (ret) {
            alert("Ocorreu um erro!");
            $('#save').attr('disabled', 'disabled');
        });
    }
}

function verificaGenpro(username, password) {
    $("#verificaLogin").html('');
    if (username != '' && password != '') {
        $.ajax({
            url: "https://www.ruralbit.com/api/api.php/getLoginGenpro",
            method: "POST",
            data: {
                'API-user': 'ifap_plugin',
                'API-pass': 'pluginIfAp2019!',
                'user': username,
                'pass': btoa(password)
            },
            dataType: 'json'
        }).done(function (ret) {
            var text = '';
            if (ret.length > 0) {
                text = '<div class="alert alert-success" role="alert">\n\
                            <b>Login válido!</b>\n\
                            <ul>\n\
                                <li>Utlizador: <b>' + ret[0].nome + '</b></li>\n\
                                <li>Entidade: <b>' + ret[0].enti + ' - ' + ret[0].nome_entidade + '</b></li>\n\
                            </ul>\n\
                        </div>';
                $('#save').removeAttr('disabled');
            } else {
                text = '<div class="alert alert-danger" role="alert">\n\
                            <b>Login inválido!</b> Por favor, verifique as suas credenciais.\n\
                        </div>';
                $('#save').attr('disabled', 'disabled');
            }
            $("#verificaLogin").html(text);
        }).error(function (ret) {
            alert("Ocorreu um erro!");
            $('#save').attr('disabled', 'disabled');
        });
    }
}

function param(object) {
    var parameters = [];
    for (var property in object) {
        if (object.hasOwnProperty(property)) {
            parameters.push(encodeURI(property + '=' + object[property]));
        }
    }

    return parameters.join('&');
}