'use strict';

function getNifExpl() {
    if (document.getElementsByName('corpo:corpo:conteudo:rosto:inputMarExp').length > 0) {
        return {
            nif: (document.getElementsByName('corpo:corpo:conteudo:rosto:inputCriadorNif').length > 0 ? document.getElementsByName('corpo:corpo:conteudo:rosto:inputCriadorNif')[0].value : ""),
            expl: (document.getElementsByName('corpo:corpo:conteudo:rosto:inputMarExp').length > 0 ? document.getElementsByName('corpo:corpo:conteudo:rosto:inputMarExp')[0].value : ""),
            nif_dest: (document.getElementsByName('corpo:corpo:conteudo:rosto:inputDestinoNif').length > 0 ? document.getElementsByName('corpo:corpo:conteudo:rosto:inputDestinoNif')[0].value : ""),
            expl_dest: (document.getElementsByName('corpo:corpo:conteudo:rosto:inputMarExpDestino').length > 0 ? document.getElementsByName('corpo:corpo:conteudo:rosto:inputMarExpDestino')[0].value : ""),
            data_saida: (document.getElementsByName('corpo:corpo:conteudo:rosto:inputDatSaida').length > 0 ? document.getElementsByName('corpo:corpo:conteudo:rosto:inputDatSaida')[0].value : ""),
            tipo_saida: (document.getElementById('corpo:corpo:conteudo:rosto:divExplDestino').children[0].children[0].children[0].children[0].children[0].length > 0 ?
                    document.getElementById('corpo:corpo:conteudo:rosto:divExplDestino').children[0].children[0].children[0].children[0].children[0].textContent : "")
        };
    } else {
        return {
            nif: (document.getElementsByName('content:inputCriadorNif').length > 0 ? document.getElementsByName('content:inputCriadorNif')[0].value : ""),
            expl: (document.getElementsByName('content:inputMarExp').length > 0 ? document.getElementsByName('content:inputMarExp')[0].value : ""),
            nif_dest: (document.getElementsByName('content:inputNifDestino').length > 0 ? document.getElementsByName('content:inputNifDestino')[0].value : ""),
            expl_dest: (document.getElementsByName('content:inputMarExpDest').length > 0 ? document.getElementsByName('content:inputMarExpDest')[0].value : ""),
            data_saida: (document.getElementsByName('content:inputDatSaida').length > 0 ? document.getElementsByName('content:inputDatSaida')[0].value : ""),
            tipo_saida: (document.querySelectorAll('[for="content:inputMarExpDest"]').length > 0 ? document.querySelectorAll('[for="content:inputMarExpDest"]')[0].textContent : "")
        };
    }
}

let tipo = "",
        addLinha = document.getElementById('addLinha'),
        addLinha1 = document.getElementById('addLinha1'),
        marcarAnims = document.getElementById('marcarAnims'),
        tab_act = 0,
        username = '',
        password = '',
        plataforma = '',
        idpart = '';

let getvars = [
    'username',
    'password',
    'idpart',
    'data_min',
    'nprocessado',
    'nif_dest',
    'expl_dest',
    'data_saida',
    'plataforma'
];

var tit = "";
chrome.storage.sync.get(getvars, function (data) {
    plataforma = data.plataforma;

    switch (plataforma) {
        case 'E':
            tit = "e-Exploração";
            break;
        case 'R':
            tit = "R.Campo";
            break;
        case 'G':
            tit = "Genpro";
            break;
    }
    if (!tit) {
        $("#blocker-text").html("Deve configurar o plugin na página de Opções");
        $("#blocker").css('height', '100%');
    }
    $('.tit-plat').html("<b>" + tit + "</b>");

    username = data.username;
    password = data.password;
    idpart = data.idpart;

    $('#data_min').val(data.data_min);
    $('#data_min1').val(data.data_min);
    $('#nprocessado').val(data.nprocessado);
    $('#nprocessado1').val(data.nprocessado);

    $('.nif_dest').val(data.nif_dest);
    $('.expl_dest').val(data.expl_dest);
    $('.data_saida').val(data.data_saida);
});

chrome.storage.local.set({
    linhas: 0,
    preenche: 0,
    nascimentos: 0,
    saidas: 0
}, function () {

});

chrome.tabs.query({active: true, currentWindow: true}, function (tabs) {
    tab_act = tabs[0].id;
    let url = tabs[0].url,
            expl = '',
            nif = '',
            title = ['', '', ''];

    chrome.scripting.executeScript({
        target: {tabId: tabs[0].id},
        function: getNifExpl
    }, function (result) {
        tipo = '';
        nif = result[0].result.nif;
        var lock = false;
        if (url.match(/idigital\.sniNasBov/i)) {
            expl = result[0].result.expl.substr(2);
            title = ["Carregar registos de nascimento", "Marcar registos de nascimento como processados no IFAP", ""];
            if (!nif) {
                title[2] = "Deve criar um novo documento para carregar os animais";
                lock = true;
            }
            $('.form-nasc').show();
            $('.form-saida').hide();
            tipo = 'nasc';
        } else if (url.match(/iDigital\.sniBovMov/i) && plataforma == 'E') {
            expl = result[0].result.expl;
            title = ["Carregar registos de saída", "Marcar registos de saída como processados no IFAP", ""];
            if (!nif) {
                title[2] = "Deve criar um documento ou selecionar o separador <b>Identificação dos Intervenientes</b>";
                lock = true;
            }
            $('.form-nasc').hide();
            $('.form-saida').show();
            if (result[0].result.tipo_saida == 'Matadouro') {
                $('.expl_dest').attr('readonly', 'readonly');
                result[0].result.expl_dest = "";
            } else {
                $('.expl_dest').removeAttr('readonly');
            }
            tipo = 'saida';
        } else if (url.match(/idigital\.sniOviMov/i) && plataforma == 'E') {
            expl = result[0].result.expl;
            title = ["Carregar registos de saída", "Marcar registos de saída como processados no IFAP", ""];
            if (!nif) {
                title[2] = "Deve criar um documento ou selecionar o separador <b>Identificação dos Intervenientes</b>";
                lock = true;
            }
            $('.form-nasc').hide();
            $('.form-saida').show();
            if (result[0].result.tipo_saida == 'Matadouro') {
                $('.expl_dest').attr('readonly', 'readonly');
                result[0].result.expl_dest = "";
            } else {
                $('.expl_dest').removeAttr('readonly');
            }
            tipo = 'saida_oc';
        } else {
            title[2] = "Funcionalidade compatível com <b>Registo de Nascimento</b> e <b>Movimentação</b> de Bovinos";
            lock = true;
        }

        chrome.storage.local.set(
                {
                    nif: nif,
                    expl: expl,
                    tipo: tipo
                },
                function () {
                    $("#popup-title").html(title[0]);
                    $("#marcar-title").html(title[1]);
                    if (lock) {
                        $('.form-nasc').hide();
                        $('.form-saida').hide();
                        $("#blocker-text").html(title[2]);
                        $("#blocker").css('height', '100%');
                    } else {
                        $('.tit-nif').html("NIF: <b>" + nif + "</b>");
                        $('.tit-expl').html("Expl.: <b>" + expl + "</b>");
                        $('.nif_dest').val(result[0].result.nif_dest);
                        $('.expl_dest').val(result[0].result.expl_dest);
                        $('.data_saida').val(result[0].result.data_saida);
                    }
                }
        );


        if (tipo == 'nasc') {
            addLinha.onclick = function (element) {
                var data_min0 = document.getElementById('data_min').value,
                        nprocessado = document.getElementById('nprocessado').value;

                let nif = '';
                let expl = '';

                $("#nanims_form").html("A carregar...");

                chrome.scripting.executeScript({
                    target: {tabId: tab_act},
                    function: getNifExpl
                }, function (result) {
                    chrome.storage.local.get(['nif', 'expl'], function (data) {
                        nif = data.nif;
                        expl = data.expl;

                        let send_data = {
                            'API-user': 'ifap_plugin',
                            'API-pass': 'pluginIfAp2019!',
                            'user': username,
                            'pass': btoa(password),
                            'nif': nif,
                            'expl': expl,
                            'idpart': idpart,
                            'dn_apos': data_min0,
                            'nprocessado': nprocessado
                        };

                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", "https://www.ruralbit.com/api/getNascimentos" + plataforma + "?" + param(send_data), true);
                        xhr.onreadystatechange = function () {
                            if (xhr.readyState == 4) {
                                if (xhr.status == 200) {
                                    var nascs = JSON.parse(xhr.responseText);

                                    $("#nanims_form").html(nascs.length + " animais carregados");
                                    chrome.storage.sync.set(
                                            {
                                                data_min: data_min0,
                                                nprocessado: nprocessado
                                            }
                                    );
                                    chrome.storage.local.set(
                                            {
                                                linhas: nascs.length,
                                                preenche: 1,
                                                nascimentos: JSON.stringify(nascs)
                                            },
                                            function () {
                                                function reload() {
                                                    window.location.reload();
                                                }

                                                chrome.scripting.executeScript({
                                                    target: {tabId: tab_act},
                                                    function: reload
                                                }, function (result) {

                                                });
                                            }
                                    );
                                } else {
                                    $("#nanims_form").html("Ocorreu um erro!");
                                }
                            }
                        };
                        xhr.send();
                    });
                });
            }

            addLinha1.onclick = function (element) {
                var data_min0 = document.getElementById('data_min1').value,
                        nprocessado = document.getElementById('nprocessado1').value;

                let nif = '';
                let expl = '';

                chrome.scripting.executeScript({
                    target: {tabId: tab_act},
                    function: getNifExpl
                }, function (result) {
                    chrome.storage.local.get(['nif', 'expl'], function (data) {
                        nif = data.nif;
                        expl = data.expl;

                        let send_data = {
                            'API-user': 'ifap_plugin',
                            'API-pass': 'pluginIfAp2019!',
                            'user': username,
                            'pass': btoa(password),
                            'nif': nif,
                            'expl': expl,
                            'dn_apos': data_min0,
                            'nprocessado': nprocessado
                        };

                        $("#nanims-marc").html("(A carregar...)");

                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", "https://www.ruralbit.com/api/getNascimentos" + plataforma + "?" + param(send_data), true);
                        xhr.onreadystatechange = function () {
                            if (xhr.readyState == 4) {
                                if (xhr.status == 200) {
                                    var nascs = JSON.parse(xhr.responseText);

                                    $("#tabela-nascs tbody").html('');
                                    nascs.forEach(function (nasc, i) {
                                        $("#tabela-nascs tbody").append("\n\
					<tr>\n\
						<td><input type='checkbox' class='anims-marc' value='" + nasc.n_sia + "' checked></td>\n\
						<td>" + nasc.n_sia + "</td>\n\
						<td>" + nasc.data_nasc + "</td>\n\
					</tr>");
                                    });
                                    $("#nanims-marc").html("(" + nascs.length + " animais)");
                                } else {
                                    $("#nanims-marc").html("(Ocorreu um erro!)");
                                }
                            }
                        };
                        xhr.send();
                    });
                });
            }

            marcarAnims.onclick = function (element) {
                let nif = '';
                let expl = '';

                let siasa = [];
                $('.anims-marc:checked').each(function (i, e) {
                    siasa.push(e.value);
                });
                let sias = siasa.length > 0 ? siasa.join("','") : "";

                if ($("#ndoc").val() == '' || $("#ndoc").val() == '0') {
                    alert('Deve preencher o número de documento a associar aos registos de nascimento.');
                    return false;
                }

                if (siasa.length == 0) {
                    alert('Deve escolher pelo menos um animal para registar o número de documento.');
                    return false;
                }

                chrome.scripting.executeScript({
                    target: {tabId: tab_act},
                    function: getNifExpl
                }, function (result) {
                    chrome.storage.local.get(['nif', 'expl'], function (data) {
                        nif = data.nif;
                        expl = data.expl;

                        let send_data = {
                            'API-user': 'ifap_plugin',
                            'API-pass': 'pluginIfAp2019!',
                            'user': username,
                            'pass': btoa(password),
                            'nif': nif,
                            'expl': expl,
                            'sias': sias,
                            'ndoc': $("#ndoc").val()
                        };

                        $("#nanims-marc").html("(A carregar...)");

                        var xhr = new XMLHttpRequest();
                        xhr.open("POST", "https://www.ruralbit.com/api/setNascimentos" + plataforma + "?" + param(send_data), true);
                        xhr.onreadystatechange = function () {
                            if (xhr.readyState == 4) {
                                if (xhr.status == 200) {
                                    var nascs = JSON.parse(xhr.responseText);

                                    if (nascs.ret == true) {
                                        $("#tabela-nascs tbody").html('');
                                        $("#ndoc").val("");
                                        $("#nanims-marc").html("");
                                        alert("O número de documento foi atualizado nos animais selecionados!");
                                    } else {
                                        alert("Não foi possível atualizar o número de documento nos animais selecionados!");
                                    }
                                } else {
                                    alert("Ocorreu um erro!");
                                }
                            }
                        };
                        xhr.send();
                    });
                });
            }
        } else if (tipo == 'saida') {
            addLinha.onclick = function (element) {
                $("#nanims_form").html("A carregar...");

                chrome.storage.local.get(['nif', 'expl'], function (data) {

                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida').value,
                        'nif_dest': document.getElementById('nif_dest').value,
                        'expl_dest': document.getElementById('expl_dest').value
                    };

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/getSaidas" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                let saidasJ = JSON.parse(xhr.responseText);
                                let saidas = [];

                                saidasJ.forEach(function (saida, i) {
                                    saidas[i] = saida.n_sia;
                                });

                                $("#nanims_form").html(saidas.length + " animais com saída no " + tit);
                                chrome.storage.sync.set(
                                        {
                                            data_saida: send_data.data_saida,
                                            nif_destino: send_data.nif_destino,
                                            expl_destino: send_data.expl_destino
                                        }
                                );
                                chrome.storage.local.set(
                                        {
                                            linhas: saidas.length,
                                            preenche: 1,
                                            saidas: JSON.stringify(saidas)
                                        },
                                        function () {
                                            function reload() {
                                                document.getElementsByClassName('nav-tabs')[0].children[2].firstElementChild.click();
                                            }

                                            chrome.scripting.executeScript({
                                                target: {tabId: tab_act},
                                                function: reload
                                            }, function (result) {

                                            });
                                        }
                                );
                            } else {
                                $("#nanims_form").html("Ocorreu um erro!");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            addLinha1.onclick = function (element) {
                chrome.storage.local.get(['nif', 'expl'], function (data) {
                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida1').value,
                        'nif_dest': document.getElementById('nif_dest1').value,
                        'expl_dest': document.getElementById('expl_dest1').value
                    };

                    $("#nanims-saida").html("(A carregar...)");

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/getSaidas" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                var saidas = JSON.parse(xhr.responseText);
                                $("#nanims-saida").html("(" + saidas.length + " animais)");
                            } else {
                                $("#nanims-saida").html("(Ocorreu um erro!)");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            marcarAnims.onclick = function (element) {
                if ($("#ndoc").val() == '' || $("#ndoc").val() == '0') {
                    alert('Deve preencher o número de documento a associar aos registos de nascimento.');
                    return false;
                }

                chrome.storage.local.get(['nif', 'expl'], function (data) {
                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida1').value,
                        'nif_dest': document.getElementById('nif_dest1').value,
                        'expl_dest': document.getElementById('expl_dest1').value,
                        'ndoc': document.getElementById('ndoc').value
                    };

                    $("#nanims-saida").html("(A carregar...)");

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/setSaidas" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                var saidas = JSON.parse(xhr.responseText);
                                if (saidas.ret == true) {
                                    $("#ndoc").val("");
                                    $("#nanims-saida").html("");
                                    alert("O número de documento foi atualizado nos animais selecionados!");
                                } else {
                                    alert("Não foi possível atualizar o número de documento nos animais selecionados!");
                                }
                            } else {
                                alert("Ocorreu um erro!");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            chrome.runtime.onMessage.addListener(
                    function (request, sender, sendResponse) {
                        if (request.contador > 0) {
                            $("#contador-ok").html(Number($("#contador-ok").html()) + 1);
                        }
                        if (request.contador < 0) {
                            $("#contador-nok").addClass('bg-danger').removeClass('bg-warning');
                            $("#contador-nok").html(Number($("#contador-nok").html()) + 1);
                            $("#tabela-nok").append("<tr><td>" + request.sia + "</td><td><i class='bi bi-x-circle-fill text-danger'></i></td></tr>");
                        }
                        sendResponse({recebido: true});
                    }
            );

        } else if (tipo == 'saida_oc') {
            addLinha.onclick = function (element) {
                $("#nanims_form").html("A carregar...");

                chrome.storage.local.get(['nif', 'expl'], function (data) {

                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida').value,
                        'nif_dest': document.getElementById('nif_dest').value,
                        'expl_dest': document.getElementById('expl_dest').value
                    };

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/getSaidasOC" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                let saidasJ = JSON.parse(xhr.responseText);
                                let saidas = [];

                                saidasJ.forEach(function (saida, i) {
                                    saidas[i] = saida.n_sia;
                                });

                                $("#nanims_form").html(saidas.length + " animais com saída no " + tit);
                                chrome.storage.sync.set(
                                        {
                                            data_saida: send_data.data_saida,
                                            nif_destino: send_data.nif_destino,
                                            expl_destino: send_data.expl_destino
                                        }
                                );
                                chrome.storage.local.set(
                                        {
                                            linhas: saidas.length,
                                            preenche: 1,
                                            saidas: JSON.stringify(saidas)
                                        },
                                        function () {
                                            function reload() {
                                                document.getElementsByClassName('nav nav-tabs')[0].children[2].firstElementChild.click();
                                            }

                                            chrome.scripting.executeScript({
                                                target: {tabId: tab_act},
                                                function: reload
                                            }, function (result) {

                                            });
                                        }
                                );
                            } else {
                                $("#nanims_form").html("Ocorreu um erro!");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            addLinha1.onclick = function (element) {
                chrome.storage.local.get(['nif', 'expl'], function (data) {
                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida1').value,
                        'nif_dest': document.getElementById('nif_dest1').value,
                        'expl_dest': document.getElementById('expl_dest1').value
                    };

                    $("#nanims-saida").html("(A carregar...)");

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/getSaidasOC" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                var saidas = JSON.parse(xhr.responseText);
                                $("#nanims-saida").html("(" + saidas.length + " animais)");
                            } else {
                                $("#nanims-saida").html("(Ocorreu um erro!)");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            marcarAnims.onclick = function (element) {
                if ($("#ndoc").val() == '' || $("#ndoc").val() == '0') {
                    alert('Deve preencher o número de documento a associar aos registos de nascimento.');
                    return false;
                }

                chrome.storage.local.get(['nif', 'expl'], function (data) {
                    let send_data = {
                        'API-user': 'ifap_plugin',
                        'API-pass': 'pluginIfAp2019!',
                        'user': username,
                        'pass': btoa(password),
                        'nif': data.nif,
                        'expl': data.expl,
                        'data_saida': document.getElementById('data_saida1').value,
                        'nif_dest': document.getElementById('nif_dest1').value,
                        'expl_dest': document.getElementById('expl_dest1').value,
                        'ndoc': document.getElementById('ndoc').value
                    };

                    $("#nanims-saida").html("(A carregar...)");

                    var xhr = new XMLHttpRequest();
                    xhr.open("POST", "https://www.ruralbit.com/api/setSaidasOC" + plataforma + "?" + param(send_data), true);
                    xhr.onreadystatechange = function () {
                        if (xhr.readyState == 4) {
                            if (xhr.status == 200) {
                                var saidas = JSON.parse(xhr.responseText);
                                if (saidas.ret == true) {
                                    $("#ndoc").val("");
                                    $("#nanims-saida").html("");
                                    alert("O número de documento foi atualizado nos animais selecionados!");
                                } else {
                                    alert("Não foi possível atualizar o número de documento nos animais selecionados!");
                                }
                            } else {
                                alert("Ocorreu um erro!");
                            }
                        }
                    };
                    xhr.send();
                });
            }

            chrome.runtime.onMessage.addListener(
                    function (request, sender, sendResponse) {
                        if (request.contador > 0) {
                            $("#contador-ok").html(Number($("#contador-ok").html()) + 1);
                        }
                        if (request.contador < 0) {
                            $("#download-button").removeClass('d-none');
                            $("#contador-nok").addClass('bg-danger').removeClass('bg-warning');
                            $("#contador-nok").html(Number($("#contador-nok").html()) + 1);
                            $("#tabela-nok").append("<tr><td>" + request.sia + "</td><td><i class='bi bi-x-circle-fill text-danger'></i></td></tr>");
                        }
                        sendResponse({recebido: true});
                    }
            );

        }

    });

    function getHeight() {
        return window.innerHeight;
    }

    chrome.scripting.executeScript({
        target: {tabId: tab_act},
        function: getHeight
    }, function (result) {
        //$('body, body > .container').css("max-height", result[0].result);
    });
});

function param(object) {
    var parameters = [];
    for (var property in object) {
        if (object.hasOwnProperty(property)) {
            parameters.push(encodeURI(property + '=' + object[property]));
        }
    }

    return parameters.join('&');
}

document.getElementById('download-button').onclick = function (element) {
    var element = document.createElement('a');
    var filename = "animais_nao_encontrados.txt";
    var text = "";

    $("#tabela-nok tr td:first-child").each(function (i, e) {
        text += $(e).text() + "\r\n";
    });

    element.setAttribute('href', 'data:text/plain;charset=utf-8,' + encodeURIComponent(text));
    element.setAttribute('download', filename);

    element.style.display = 'none';
    document.body.appendChild(element);

    element.click();

    document.body.removeChild(element);
};